#include "stdafx.h"
#include "SpeedDome.h"
#include "ControlDlg.h"
#include "misc.h"
#include "Dome.h"
#include "GlobalVar.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//###############################################################
//
// S_GetDomeNameFiles(WORD Y_Point,char *Para)
//
// Y_Point	: Preset point which you want it data.
// Y_Para	: Preset point parameter string 
//###############################################################
void CDome::S_GetDomeNameFiles(UINT Num,char *Para)
{

HANDLE			hPT,hMap;
unsigned char 	*Fptr;
UINT			Temp;
UINT			DomeID;

DomeID=(UINT)G_DomeID;

hPT=CreateFile("DomeName.rec",GENERIC_READ,FILE_SHARE_READ,NULL,
				OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
hMap=CreateFileMapping( hPT,NULL,PAGE_READONLY,0,0,NULL);
Fptr=(unsigned char *)MapViewOfFile(hMap,FILE_MAP_READ,0,0,0);

Num=(Num-1)*16;

for(int i=0;i<=15;i++)
	{
	Temp=*(Fptr+i+Num);
	if(Temp==0xff)
		*(Para+i)=0;
	else
		*(Para+i)=*(Fptr+i+Num);
	}

UnmapViewOfFile(Fptr); 
CloseHandle(hMap);
CloseHandle(hPT);

}

//###############################################################
//
// S_WriteDomeNameFiles(WORD Y_Point,char *Para)
//
// Y_Point	: Preset point which you want it data.
// Y_Para	: Preset point parameter string 
//###############################################################
void CDome::S_WriteDomeNameFiles(UINT Num,char *Para)
{

HANDLE			hPT,hMap;
unsigned char 	*Fptr;
UINT			DomeID;

DomeID=(UINT)G_DomeID;

hPT=CreateFile("DomeName.rec",GENERIC_READ|GENERIC_WRITE,
			   FILE_SHARE_WRITE,NULL,OPEN_EXISTING,
			   FILE_ATTRIBUTE_NORMAL,NULL);
hMap=CreateFileMapping( hPT,NULL,PAGE_READWRITE,0,0,NULL);
Fptr=(unsigned char *)MapViewOfFile(hMap,FILE_MAP_WRITE,0,0,0);

Num=(Num-1)*16;

for(int i=0;i<=15;i++)
	{
	*(Fptr+i+Num)=Para[i];
	}

UnmapViewOfFile(Fptr); 
CloseHandle(hMap);
CloseHandle(hPT);

}


//###############################################################
//
// int S_DomeIDToNum(UINT ID)
//
// ID : Dome ID
//###############################################################
UINT	CDome::S_DomeIDToNum(UINT ID,LPTSTR *IDBName)
{
UINT	Num;
UINT	IDBBuffer[9]=
		{	IDB_DOME_NUM1D ,IDB_DOME_NUM2D ,IDB_DOME_NUM3D,
			IDB_DOME_NUM4D ,IDB_DOME_NUM5D ,IDB_DOME_NUM6D,
			IDB_DOME_NUM7D ,IDB_DOME_NUM8D ,IDB_DOME_MORED	};

switch(ID)
	{
	case IDC_DOME_MORE  : Num=9;	break;
	//--------
	case IDC_DOME_NUM1  : Num=1;	break;	case IDC_DOME_NUM2  : Num=2;	break;
	case IDC_DOME_NUM3  : Num=3;	break;	case IDC_DOME_NUM4  : Num=4;	break;
	case IDC_DOME_NUM5  : Num=5;	break;	case IDC_DOME_NUM6  : Num=6;	break;
	case IDC_DOME_NUM7  : Num=7;	break;	case IDC_DOME_NUM8  : Num=8;	break;
	case IDC_DOME_NUM9  : Num=9;	break;	case IDC_DOME_NUM10 : Num=10;	break;
	case IDC_DOME_NUM11 : Num=11;	break;	case IDC_DOME_NUM12 : Num=12;	break;
	case IDC_DOME_NUM13 : Num=13;	break;	case IDC_DOME_NUM14 : Num=14;	break;
	case IDC_DOME_NUM15 : Num=15;	break;	case IDC_DOME_NUM16 : Num=16;	break;
	case IDC_DOME_NUM17 : Num=17;	break;	case IDC_DOME_NUM18 : Num=18;	break;
	case IDC_DOME_NUM19 : Num=19;	break;	case IDC_DOME_NUM20 : Num=20;	break;
	//-------
	case IDC_DOME_NUM21 : Num=21;	break;	case IDC_DOME_NUM22 : Num=22;	break;
	case IDC_DOME_NUM23 : Num=23;	break;	case IDC_DOME_NUM24 : Num=24;	break;
	case IDC_DOME_NUM25 : Num=25;	break;	case IDC_DOME_NUM26 : Num=26;	break;
	case IDC_DOME_NUM27 : Num=27;	break;	case IDC_DOME_NUM28 : Num=28;	break;
	case IDC_DOME_NUM29 : Num=29;	break;	case IDC_DOME_NUM30 : Num=30;	break;
	case IDC_DOME_NUM31 : Num=31;	break;	case IDC_DOME_NUM32 : Num=32;	break;
	case IDC_DOME_NUM33 : Num=33;	break;	case IDC_DOME_NUM34 : Num=34;	break;
	case IDC_DOME_NUM35 : Num=35;	break;	case IDC_DOME_NUM36 : Num=36;	break;
	case IDC_DOME_NUM37 : Num=37;	break;	case IDC_DOME_NUM38 : Num=38;	break;
	case IDC_DOME_NUM39 : Num=39;	break;	case IDC_DOME_NUM40 : Num=40;	break;
	//------
	case IDC_DOME_NUM41 : Num=41;	break;	case IDC_DOME_NUM42 : Num=42;	break;
	case IDC_DOME_NUM43 : Num=43;	break;	case IDC_DOME_NUM44 : Num=44;	break;
	case IDC_DOME_NUM45 : Num=45;	break;	case IDC_DOME_NUM46 : Num=46;	break;
	case IDC_DOME_NUM47 : Num=47;	break;	case IDC_DOME_NUM48 : Num=48;	break;
	case IDC_DOME_NUM49 : Num=49;	break;	case IDC_DOME_NUM50 : Num=50;	break;
	case IDC_DOME_NUM51 : Num=51;	break;	case IDC_DOME_NUM52 : Num=52;	break;
	case IDC_DOME_NUM53 : Num=53;	break;	case IDC_DOME_NUM54 : Num=54;	break;
	case IDC_DOME_NUM55 : Num=55;	break;	case IDC_DOME_NUM56 : Num=56;	break;
	case IDC_DOME_NUM57 : Num=57;	break;	case IDC_DOME_NUM58 : Num=58;	break;
	case IDC_DOME_NUM59 : Num=59;	break;	case IDC_DOME_NUM60 : Num=60;	break;
	//-----
	case IDC_DOME_NUM61 : Num=61;	break;	case IDC_DOME_NUM62 : Num=62;	break;
	case IDC_DOME_NUM63 : Num=63;	break;	case IDC_DOME_NUM64 : Num=64;	break;
	case IDC_DOME_NUM65 : Num=65;	break;	case IDC_DOME_NUM66 : Num=66;	break;
	case IDC_DOME_NUM67 : Num=67;	break;	case IDC_DOME_NUM68 : Num=68;	break;
	case IDC_DOME_NUM69 : Num=69;	break;	case IDC_DOME_NUM70 : Num=70;	break;
	case IDC_DOME_NUM71 : Num=71;	break;	case IDC_DOME_NUM72 : Num=72;	break;
	case IDC_DOME_NUM73 : Num=73;	break;	case IDC_DOME_NUM74 : Num=74;	break;
	case IDC_DOME_NUM75 : Num=75;	break;	case IDC_DOME_NUM76 : Num=76;	break;
	case IDC_DOME_NUM77 : Num=77;	break;	case IDC_DOME_NUM78 : Num=78;	break;
	case IDC_DOME_NUM79 : Num=79;	break;	case IDC_DOME_NUM80 : Num=80;	break;
	//-----
	case IDC_DOME_NUM81 : Num=81;	break;	case IDC_DOME_NUM82 : Num=82;	break;
	case IDC_DOME_NUM83 : Num=83;	break;	case IDC_DOME_NUM84 : Num=84;	break;
	case IDC_DOME_NUM85 : Num=85;	break;	case IDC_DOME_NUM86 : Num=86;	break;
	case IDC_DOME_NUM87 : Num=87;	break;	case IDC_DOME_NUM88 : Num=88;	break;
	case IDC_DOME_NUM89 : Num=89;	break;	case IDC_DOME_NUM90 : Num=90;	break;
	case IDC_DOME_NUM91 : Num=91;	break;	case IDC_DOME_NUM92 : Num=92;	break;
	case IDC_DOME_NUM93 : Num=93;	break;	case IDC_DOME_NUM94 : Num=94;	break;
	case IDC_DOME_NUM95 : Num=95;	break;	case IDC_DOME_NUM96 : Num=96;	break;
	case IDC_DOME_NUM97 : Num=97;	break;	case IDC_DOME_NUM98 : Num=98;	break;
	case IDC_DOME_NUM99 : Num=99;	break;	case IDC_DOME_NUM100: Num=100;break;
	//-----
	case IDC_DOME_NUM101 : Num=101;	break;	case IDC_DOME_NUM102 : Num=102;	break;
	case IDC_DOME_NUM103 : Num=103;	break;	case IDC_DOME_NUM104 : Num=104;	break;
	case IDC_DOME_NUM105 : Num=105;	break;	case IDC_DOME_NUM106 : Num=106;	break;
	case IDC_DOME_NUM107 : Num=107;	break;	case IDC_DOME_NUM108 : Num=108;	break;
	case IDC_DOME_NUM109 : Num=109;	break;	case IDC_DOME_NUM110 : Num=110;	break;
	case IDC_DOME_NUM111 : Num=111;	break;	case IDC_DOME_NUM112 : Num=112;	break;
	case IDC_DOME_NUM113 : Num=113;	break;	case IDC_DOME_NUM114 : Num=114;	break;
	case IDC_DOME_NUM115 : Num=115;	break;	case IDC_DOME_NUM116 : Num=116;	break;
	case IDC_DOME_NUM117 : Num=117;	break;	case IDC_DOME_NUM118 : Num=118;	break;
	case IDC_DOME_NUM119 : Num=119;	break;	case IDC_DOME_NUM120 : Num=120;	break;
	//-----
	case IDC_DOME_NUM121 : Num=121;	break;	case IDC_DOME_NUM122 : Num=122;	break;
	case IDC_DOME_NUM123 : Num=123;	break;	case IDC_DOME_NUM124 : Num=124;	break;
	case IDC_DOME_NUM125 : Num=125;	break;	case IDC_DOME_NUM126 : Num=126;	break;
	case IDC_DOME_NUM127 : Num=127;	break;	case IDC_DOME_NUM128 : Num=128;	break;

	}
if (Num<=9)
	*IDBName=MAKEINTRESOURCE( IDBBuffer[Num-1] );

return (Num);
}


//###############################################################
//
// UINT S_DomeNumToID(UINT Num)
//
// ID : Dome ID
//###############################################################
UINT	CDome::S_DomeNumToID(UINT Num)
{
UINT	ID;

switch(Num)
	{
	//--------
	case  1: ID=IDC_DOME_NUM1;	break;	case  2: ID=IDC_DOME_NUM2;	break;
	case  3: ID=IDC_DOME_NUM3;	break;	case  4: ID=IDC_DOME_NUM4;	break;
	case  5: ID=IDC_DOME_NUM5;	break;	case  6: ID=IDC_DOME_NUM6;	break;
	case  7: ID=IDC_DOME_NUM7;	break;	case  8: ID=IDC_DOME_NUM8;	break;
	case  9: ID=IDC_DOME_NUM9;	break;	case 10: ID=IDC_DOME_NUM10;	break;
	case 11: ID=IDC_DOME_NUM11;	break;	case 12: ID=IDC_DOME_NUM12;	break;
	case 13: ID=IDC_DOME_NUM13;	break;	case 14: ID=IDC_DOME_NUM14;	break;
	case 15: ID=IDC_DOME_NUM15;	break;	case 16: ID=IDC_DOME_NUM16;	break;
	case 17: ID=IDC_DOME_NUM17;	break;	case 18: ID=IDC_DOME_NUM18;	break;
	case 19: ID=IDC_DOME_NUM19;	break;	case 20: ID=IDC_DOME_NUM20;	break;
	//-------
	case 21: ID=IDC_DOME_NUM21;	break;	case 22: ID=IDC_DOME_NUM22;	break;
	case 23: ID=IDC_DOME_NUM23;	break;	case 24: ID=IDC_DOME_NUM24;	break;
	case 25: ID=IDC_DOME_NUM25;	break;	case 26: ID=IDC_DOME_NUM26;	break;
	case 27: ID=IDC_DOME_NUM27;	break;	case 28: ID=IDC_DOME_NUM28;	break;
	case 29: ID=IDC_DOME_NUM29;	break;	case 30: ID=IDC_DOME_NUM30;	break;
	case 31: ID=IDC_DOME_NUM31;	break;	case 32: ID=IDC_DOME_NUM32;	break;
	case 33: ID=IDC_DOME_NUM33;	break;	case 34: ID=IDC_DOME_NUM34;	break;
	case 35: ID=IDC_DOME_NUM35;	break;	case 36: ID=IDC_DOME_NUM36;	break;
	case 37: ID=IDC_DOME_NUM37;	break;	case 38: ID=IDC_DOME_NUM38;	break;
	case 39: ID=IDC_DOME_NUM39;	break;	case 40: ID=IDC_DOME_NUM40;	break;
	//-------
	case 41: ID=IDC_DOME_NUM41;	break;	case 42: ID=IDC_DOME_NUM42;	break;
	case 43: ID=IDC_DOME_NUM43;	break;	case 44: ID=IDC_DOME_NUM44;	break;
	case 45: ID=IDC_DOME_NUM45;	break;	case 46: ID=IDC_DOME_NUM46;	break;
	case 47: ID=IDC_DOME_NUM47;	break;	case 48: ID=IDC_DOME_NUM48;	break;
	case 49: ID=IDC_DOME_NUM49;	break;	case 50: ID=IDC_DOME_NUM50;	break;
	case 51: ID=IDC_DOME_NUM51;	break;	case 52: ID=IDC_DOME_NUM52;	break;
	case 53: ID=IDC_DOME_NUM53;	break;	case 54: ID=IDC_DOME_NUM54;	break;
	case 55: ID=IDC_DOME_NUM55;	break;	case 56: ID=IDC_DOME_NUM56;	break;
	case 57: ID=IDC_DOME_NUM57;	break;	case 58: ID=IDC_DOME_NUM58;	break;
	case 59: ID=IDC_DOME_NUM59;	break;	case 60: ID=IDC_DOME_NUM60;	break;
	//-------
	case 61: ID=IDC_DOME_NUM61;	break;	case 62: ID=IDC_DOME_NUM62;	break;
	case 63: ID=IDC_DOME_NUM63;	break;	case 64: ID=IDC_DOME_NUM64;	break;
	case 65: ID=IDC_DOME_NUM65;	break;	case 66: ID=IDC_DOME_NUM66;	break;
	case 67: ID=IDC_DOME_NUM67;	break;	case 68: ID=IDC_DOME_NUM68;	break;
	case 69: ID=IDC_DOME_NUM69;	break;	case 70: ID=IDC_DOME_NUM70;	break;
	case 71: ID=IDC_DOME_NUM71;	break;	case 72: ID=IDC_DOME_NUM72;	break;
	case 73: ID=IDC_DOME_NUM73;	break;	case 74: ID=IDC_DOME_NUM74;	break;
	case 75: ID=IDC_DOME_NUM75;	break;	case 76: ID=IDC_DOME_NUM76;	break;
	case 77: ID=IDC_DOME_NUM77;	break;	case 78: ID=IDC_DOME_NUM78;	break;
	case 79: ID=IDC_DOME_NUM79;	break;	case 80: ID=IDC_DOME_NUM80;	break;
	//-------
	case 81: ID=IDC_DOME_NUM81;	break;	case 82: ID=IDC_DOME_NUM82;	break;
	case 83: ID=IDC_DOME_NUM83;	break;	case 84: ID=IDC_DOME_NUM84;	break;
	case 85: ID=IDC_DOME_NUM85;	break;	case 86: ID=IDC_DOME_NUM86;	break;
	case 87: ID=IDC_DOME_NUM87;	break;	case 88: ID=IDC_DOME_NUM88;	break;
	case 89: ID=IDC_DOME_NUM89;	break;	case 90: ID=IDC_DOME_NUM90;	break;
	case 91: ID=IDC_DOME_NUM91;	break;	case 92: ID=IDC_DOME_NUM92;	break;
	case 93: ID=IDC_DOME_NUM93;	break;	case 94: ID=IDC_DOME_NUM94;	break;
	case 95: ID=IDC_DOME_NUM95;	break;	case 96: ID=IDC_DOME_NUM96;	break;
	case 97: ID=IDC_DOME_NUM97;	break;	case 98: ID=IDC_DOME_NUM98;	break;
	case 99: ID=IDC_DOME_NUM99;	break;	case 100: ID=IDC_DOME_NUM100;	break;
	//-------
	case 101: ID=IDC_DOME_NUM101;	break;	case 102: ID=IDC_DOME_NUM102;	break;
	case 103: ID=IDC_DOME_NUM103;	break;	case 104: ID=IDC_DOME_NUM104;	break;
	case 105: ID=IDC_DOME_NUM105;	break;	case 106: ID=IDC_DOME_NUM106;	break;
	case 107: ID=IDC_DOME_NUM107;	break;	case 108: ID=IDC_DOME_NUM108;	break;
	case 109: ID=IDC_DOME_NUM109;	break;	case 110: ID=IDC_DOME_NUM110;	break;
	case 111: ID=IDC_DOME_NUM111;	break;	case 112: ID=IDC_DOME_NUM112;	break;
	case 113: ID=IDC_DOME_NUM113;	break;	case 114: ID=IDC_DOME_NUM114;	break;
	case 115: ID=IDC_DOME_NUM115;	break;	case 116: ID=IDC_DOME_NUM116;	break;
	case 117: ID=IDC_DOME_NUM117;	break;	case 118: ID=IDC_DOME_NUM118;	break;
	case 119: ID=IDC_DOME_NUM119;	break;	case 120: ID=IDC_DOME_NUM120;	break;
	//-------
	case 121: ID=IDC_DOME_NUM121;	break;	case 122: ID=IDC_DOME_NUM122;	break;
	case 123: ID=IDC_DOME_NUM123;	break;	case 124: ID=IDC_DOME_NUM124;	break;
	case 125: ID=IDC_DOME_NUM125;	break;	case 126: ID=IDC_DOME_NUM126;	break;
	case 127: ID=IDC_DOME_NUM127;	break;	case 128: ID=IDC_DOME_NUM128;	break;
	case 129: ID=IDC_DOME_NUM129;	break;	case 130: ID=IDC_DOME_NUM130;	break;
	case 131: ID=IDC_DOME_NUM131;	break;	case 132: ID=IDC_DOME_NUM132;	break;
	case 133: ID=IDC_DOME_NUM133;	break;	case 134: ID=IDC_DOME_NUM134;	break;
	case 135: ID=IDC_DOME_NUM135;	break;	case 136: ID=IDC_DOME_NUM136;	break;
	case 137: ID=IDC_DOME_NUM137;	break;	case 138: ID=IDC_DOME_NUM138;	break;
	case 139: ID=IDC_DOME_NUM139;	break;	case 140: ID=IDC_DOME_NUM140;	break;
	//-------
	case 141: ID=IDC_DOME_NUM141;	break;	case 142: ID=IDC_DOME_NUM142;	break;
	case 143: ID=IDC_DOME_NUM143;	break;	case 144: ID=IDC_DOME_NUM144;	break;
	case 145: ID=IDC_DOME_NUM145;	break;	case 146: ID=IDC_DOME_NUM146;	break;
	case 147: ID=IDC_DOME_NUM147;	break;	case 148: ID=IDC_DOME_NUM148;	break;
	case 149: ID=IDC_DOME_NUM149;	break;	case 150: ID=IDC_DOME_NUM150;	break;
	case 151: ID=IDC_DOME_NUM151;	break;	case 152: ID=IDC_DOME_NUM152;	break;
	case 153: ID=IDC_DOME_NUM153;	break;	case 154: ID=IDC_DOME_NUM154;	break;
	case 155: ID=IDC_DOME_NUM155;	break;	case 156: ID=IDC_DOME_NUM156;	break;
	case 157: ID=IDC_DOME_NUM157;	break;	case 158: ID=IDC_DOME_NUM158;	break;
	case 159: ID=IDC_DOME_NUM159;	break;	case 160: ID=IDC_DOME_NUM160;	break;
	//-------
	case 161: ID=IDC_DOME_NUM161;	break;	case 162: ID=IDC_DOME_NUM162;	break;
	case 163: ID=IDC_DOME_NUM163;	break;	case 164: ID=IDC_DOME_NUM164;	break;
	case 165: ID=IDC_DOME_NUM165;	break;	case 166: ID=IDC_DOME_NUM166;	break;
	case 167: ID=IDC_DOME_NUM167;	break;	case 168: ID=IDC_DOME_NUM168;	break;
	case 169: ID=IDC_DOME_NUM169;	break;	case 170: ID=IDC_DOME_NUM170;	break;
	case 171: ID=IDC_DOME_NUM171;	break;	case 172: ID=IDC_DOME_NUM172;	break;
	case 173: ID=IDC_DOME_NUM173;	break;	case 174: ID=IDC_DOME_NUM174;	break;
	case 175: ID=IDC_DOME_NUM175;	break;	case 176: ID=IDC_DOME_NUM176;	break;
	case 177: ID=IDC_DOME_NUM177;	break;	case 178: ID=IDC_DOME_NUM178;	break;
	case 179: ID=IDC_DOME_NUM179;	break;	case 180: ID=IDC_DOME_NUM180;	break;
	//-------
	case 181: ID=IDC_DOME_NUM181;	break;	case 182: ID=IDC_DOME_NUM182;	break;
	case 183: ID=IDC_DOME_NUM183;	break;	case 184: ID=IDC_DOME_NUM184;	break;
	case 185: ID=IDC_DOME_NUM185;	break;	case 186: ID=IDC_DOME_NUM186;	break;
	case 187: ID=IDC_DOME_NUM187;	break;	case 188: ID=IDC_DOME_NUM188;	break;
	case 189: ID=IDC_DOME_NUM189;	break;	case 190: ID=IDC_DOME_NUM190;	break;
	case 191: ID=IDC_DOME_NUM191;	break;	case 192: ID=IDC_DOME_NUM192;	break;
	case 193: ID=IDC_DOME_NUM193;	break;	case 194: ID=IDC_DOME_NUM194;	break;
	case 195: ID=IDC_DOME_NUM195;	break;	case 196: ID=IDC_DOME_NUM196;	break;
	case 197: ID=IDC_DOME_NUM197;	break;	case 198: ID=IDC_DOME_NUM198;	break;
	case 199: ID=IDC_DOME_NUM199;	break;	case 200: ID=IDC_DOME_NUM200;	break;
	//-------
	case 201: ID=IDC_DOME_NUM201;	break;	case 202: ID=IDC_DOME_NUM202;	break;
	case 203: ID=IDC_DOME_NUM203;	break;	case 204: ID=IDC_DOME_NUM204;	break;
	case 205: ID=IDC_DOME_NUM205;	break;	case 206: ID=IDC_DOME_NUM206;	break;
	case 207: ID=IDC_DOME_NUM207;	break;	case 208: ID=IDC_DOME_NUM208;	break;
	case 209: ID=IDC_DOME_NUM209;	break;	case 210: ID=IDC_DOME_NUM210;	break;
	case 211: ID=IDC_DOME_NUM211;	break;	case 212: ID=IDC_DOME_NUM212;	break;
	case 213: ID=IDC_DOME_NUM213;	break;	case 214: ID=IDC_DOME_NUM214;	break;
	case 215: ID=IDC_DOME_NUM215;	break;	case 216: ID=IDC_DOME_NUM216;	break;
	case 217: ID=IDC_DOME_NUM217;	break;	case 218: ID=IDC_DOME_NUM218;	break;
	case 219: ID=IDC_DOME_NUM219;	break;	case 220: ID=IDC_DOME_NUM220;	break;
	//-------
	case 221: ID=IDC_DOME_NUM221;	break;	case 222: ID=IDC_DOME_NUM222;	break;
	case 223: ID=IDC_DOME_NUM223;	break;	case 224: ID=IDC_DOME_NUM224;	break;
	case 225: ID=IDC_DOME_NUM225;	break;	case 226: ID=IDC_DOME_NUM226;	break;
	case 227: ID=IDC_DOME_NUM227;	break;	case 228: ID=IDC_DOME_NUM228;	break;
	case 229: ID=IDC_DOME_NUM229;	break;	case 230: ID=IDC_DOME_NUM230;	break;
	case 231: ID=IDC_DOME_NUM231;	break;	case 232: ID=IDC_DOME_NUM232;	break;
	case 233: ID=IDC_DOME_NUM233;	break;	case 234: ID=IDC_DOME_NUM234;	break;
	case 235: ID=IDC_DOME_NUM235;	break;	case 236: ID=IDC_DOME_NUM236;	break;
	case 237: ID=IDC_DOME_NUM237;	break;	case 238: ID=IDC_DOME_NUM238;	break;
	case 239: ID=IDC_DOME_NUM239;	break;	case 240: ID=IDC_DOME_NUM240;	break;
	//-------
	case 241: ID=IDC_DOME_NUM241;	break;	case 242: ID=IDC_DOME_NUM242;	break;
	case 243: ID=IDC_DOME_NUM243;	break;	case 244: ID=IDC_DOME_NUM244;	break;
	case 245: ID=IDC_DOME_NUM245;	break;	case 246: ID=IDC_DOME_NUM246;	break;
	case 247: ID=IDC_DOME_NUM247;	break;	case 248: ID=IDC_DOME_NUM248;	break;
	case 249: ID=IDC_DOME_NUM249;	break;	case 250: ID=IDC_DOME_NUM250;	break;
	case 251: ID=IDC_DOME_NUM251;	break;	case 252: ID=IDC_DOME_NUM252;	break;
	case 253: ID=IDC_DOME_NUM253;	break;	case 254: ID=IDC_DOME_NUM254;	break;
	case 255: ID=IDC_DOME_NUM255;	break;	case 256: ID=IDC_DOME_NUM256;	break;
	//-------
	}
return (ID);
}
